! CMD Version:2
! Version 2 enables expanded acceptable characters for object names.
! If unspecified, set to 1 or set to an invalid value, Adams View assumes traditional naming requirements.
!
!-------------------------- Default Units for Model ---------------------------!
!
!
defaults units  &
   length = meter  &
   angle = deg  &
   force = newton  &
   mass = kg  &
   time = sec
!
defaults units  &
   coordinate_system_type = cartesian  &
   orientation_type = body313
!
!--------------------------- Model Specific Colors ----------------------------!
!
!
if condition = (! db_exists(".colors.DDM_41"))
!
color create  &
   color_name = .colors.DDM_41  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_41  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_43"))
!
color create  &
   color_name = .colors.DDM_43  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_43  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_54"))
!
color create  &
   color_name = .colors.DDM_54  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
else 
!
color modify  &
   color_name = .colors.DDM_54  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
end 
!
if condition = (! db_exists(".colors.DDM_55"))
!
color create  &
   color_name = .colors.DDM_55  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_55  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
if condition = (! db_exists(".colors.DDM_56"))
!
color create  &
   color_name = .colors.DDM_56  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
else 
!
color modify  &
   color_name = .colors.DDM_56  &
   red_component = 0.501961  &
   blue_component = 1.0  &
   green_component = 0.0
!
end 
!
if condition = (! db_exists(".colors.DDM_57"))
!
color create  &
   color_name = .colors.DDM_57  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
else 
!
color modify  &
   color_name = .colors.DDM_57  &
   red_component = 0.823529  &
   blue_component = 1.0  &
   green_component = 0.823529
!
end 
!
!------------------------ Default Attributes for Model ------------------------!
!
!
defaults attributes  &
   inheritance = bottom_up  &
   icon_visibility = off  &
   grid_visibility = off  &
   size_of_icons = 0.1  &
   spacing_for_grid = 0.6
!
!--------------------------- Plugins used by Model ----------------------------!
!
!
plugin load  &
   plugin_name = .MDI.plugins.controls
!
!------------------------------ Adams View Model ------------------------------!
!
!
model create  &
   model_name = Flap_Mechanism  &
   title = "ADAMS/View model name: model1"
!
model attributes  &
   model_name = .Flap_Mechanism  &
   size_of_icons = 0.1
!
view erase
!
!-------------------------------- Data storage --------------------------------!
!
!
data_element create variable  &
   variable_name = .Flap_Mechanism.Input_force  &
   adams_id = 10  &
   function = ""
!
data_element create variable  &
   variable_name = .Flap_Mechanism.spostamento  &
   adams_id = 11  &
   function = ""
!
data_element create variable  &
   variable_name = .Flap_Mechanism.speed  &
   adams_id = 12  &
   function = ""
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_1  &
   adams_id = 54  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      3.87765065E-02, 0.0, 0.0,  &
      7.75509777E-02, 3.9729369714E-04, 0.0,  &
      0.1163193431, 1.1918394E-03, 0.0,  &
      0.1550775328, 2.3835537E-03, 0.0,  &
      0.1938214782, 3.9723114E-03, 0.0,  &
      0.232547112, 5.9579458E-03, 0.0,  &
      0.2712503689, 8.3402485E-03, 0.0,  &
      0.3099271858, 1.11189694E-02, 0.0,  &
      0.3485735026, 1.42938166E-02, 0.0,  &
      0.3871852623, 1.78644571E-02, 0.0,  &
      0.4257584114, 2.18305159E-02, 0.0,  &
      0.4642889007, 2.61915766E-02, 0.0,  &
      0.5027726854, 3.09471816E-02, 0.0,  &
      0.5412057253, 3.60968314E-02, 0.0,  &
      0.5795839861, 4.16399856E-02, 0.0,  &
      0.6179034388, 4.75760622E-02, 0.0,  &
      0.6561600606, 5.39044381E-02, 0.0,  &
      0.6943498356, 6.06244489E-02, 0.0,  &
      0.7324687546, 6.77353892E-02, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_55  &
   adams_id = 60  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      3.87765065E-02, 0.0, 0.0,  &
      7.75509777E-02, 3.9729369714E-04, 0.0,  &
      0.1163193431, 1.1918394E-03, 0.0,  &
      0.1550775328, 2.3835537E-03, 0.0,  &
      0.1938214782, 3.9723114E-03, 0.0,  &
      0.232547112, 5.9579458E-03, 0.0,  &
      0.2712503689, 8.3402485E-03, 0.0,  &
      0.3099271858, 1.11189694E-02, 0.0,  &
      0.3485735026, 1.42938166E-02, 0.0,  &
      0.3871852623, 1.78644571E-02, 0.0,  &
      0.4257584114, 2.18305159E-02, 0.0,  &
      0.4642889007, 2.61915766E-02, 0.0,  &
      0.5027726854, 3.09471816E-02, 0.0,  &
      0.5412057253, 3.60968314E-02, 0.0,  &
      0.5795839861, 4.16399856E-02, 0.0,  &
      0.6179034388, 4.75760622E-02, 0.0,  &
      0.6561600606, 5.39044381E-02, 0.0,  &
      0.6943498356, 6.06244489E-02, 0.0,  &
      0.7324687546, 6.77353892E-02, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_61  &
   adams_id = 87  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      2.81118562E-02, 0.0, 0.0,  &
      5.62219733E-02, 3.1269110742E-04, 0.0,  &
      8.43268733E-02, 9.3803463384E-04, 0.0,  &
      0.1124230788, 1.8759532E-03, 0.0,  &
      0.1405071137, 3.1263308E-03, 0.0,  &
      0.1685755031, 4.6890127E-03, 0.0,  &
      0.1966247742, 6.5638055E-03, 0.0,  &
      0.2246514566, 8.7504773E-03, 0.0,  &
      0.2526520825, 1.12487575E-02, 0.0,  &
      0.2806231876, 1.40583371E-02, 0.0,  &
      0.3085613111, 1.71788684E-02, 0.0,  &
      0.3364629962, 2.06099652E-02, 0.0,  &
      0.3643247908, 2.43512032E-02, 0.0,  &
      0.3921432475, 2.84021194E-02, 0.0,  &
      0.4199149246, 3.27622126E-02, 0.0,  &
      0.4476363858, 3.74309433E-02, 0.0,  &
      0.4753042013, 4.24077338E-02, 0.0,  &
      0.5029149478, 4.76919685E-02, 0.0,  &
      0.5304652091, 5.32829935E-02, 0.0  &
   units = "length"
!
data_element create matrix full  &
   matrix_name = .Flap_Mechanism.MATRIX_94  &
   adams_id = 96  &
   input_order = by_row  &
   row_count = 20  &
   column_count = 3  &
   values =  &
      0.0, 0.0, 0.0,  &
      2.81118562E-02, 0.0, 0.0,  &
      5.62219733E-02, 3.1269110742E-04, 0.0,  &
      8.43268733E-02, 9.3803463384E-04, 0.0,  &
      0.1124230788, 1.8759532E-03, 0.0,  &
      0.1405071137, 3.1263308E-03, 0.0,  &
      0.1685755031, 4.6890127E-03, 0.0,  &
      0.1966247742, 6.5638055E-03, 0.0,  &
      0.2246514566, 8.7504773E-03, 0.0,  &
      0.2526520825, 1.12487575E-02, 0.0,  &
      0.2806231876, 1.40583371E-02, 0.0,  &
      0.3085613111, 1.71788684E-02, 0.0,  &
      0.3364629962, 2.06099652E-02, 0.0,  &
      0.3643247908, 2.43512032E-02, 0.0,  &
      0.3921432475, 2.84021194E-02, 0.0,  &
      0.4199149246, 3.27622126E-02, 0.0,  &
      0.4476363858, 3.74309433E-02, 0.0,  &
      0.4753042013, 4.24077338E-02, 0.0,  &
      0.5029149478, 4.76919685E-02, 0.0,  &
      0.5304652091, 5.32829935E-02, 0.0  &
   units = "length"
!
data_element create plant input  &
   plant_input_name = .Flap_Mechanism.PINPUT_1  &
   adams_id = 1  &
   variable_name = .Flap_Mechanism.Input_force
!
data_element create plant output  &
   plant_output_name = .Flap_Mechanism.POUTPUT_1  &
   adams_id = 1  &
   variable_name =  &
      .Flap_Mechanism.spostamento,  &
      .Flap_Mechanism.speed
!
data_element create spline  &
   spline_name = .Flap_Mechanism.myspl  &
   adams_id = 1  &
   x = 0.0, 1.0E-02, 2.0E-02, 3.0E-02, 4.0E-02, 5.0E-02, 6.0E-02, 7.0E-02,  &
       8.0E-02, 9.0E-02, 0.1, 0.11, 0.12, 0.13, 0.14, 0.15, 0.16, 0.17, 0.18,  &
       0.19, 0.2, 0.21, 0.22, 0.23, 0.24, 0.25, 0.26, 0.27, 0.28, 0.29, 0.3,  &
       0.31, 0.32, 0.33, 0.34, 0.35, 0.36, 0.37, 0.38, 0.39, 0.4, 0.41, 0.42,  &
       0.43, 0.44, 0.45, 0.46, 0.47, 0.48, 0.49, 0.5, 0.51, 0.52, 0.53, 0.54,  &
       0.55, 0.56, 0.57, 0.58, 0.59, 0.6, 0.61, 0.62, 0.63, 0.64, 0.65, 0.66,  &
       0.67, 0.68, 0.69, 0.7, 0.71, 0.72, 0.73, 0.74, 0.75, 0.76, 0.77, 0.78,  &
       0.79, 0.8, 0.81, 0.82, 0.83, 0.84, 0.85, 0.86, 0.87, 0.88, 0.89, 0.9,  &
       0.91, 0.92, 0.93, 0.94, 0.95, 0.96, 0.97, 0.98, 0.99, 1.0, 1.01, 1.02,  &
       1.03, 1.04, 1.05, 1.06, 1.07, 1.08, 1.09, 1.1, 1.11, 1.12, 1.13, 1.14,  &
       1.15, 1.16, 1.17, 1.18, 1.19, 1.2, 1.21, 1.22, 1.23, 1.24, 1.25, 1.26,  &
       1.27, 1.28, 1.29, 1.3, 1.31, 1.32, 1.33, 1.34, 1.35, 1.36, 1.37, 1.38,  &
       1.39, 1.4, 1.41, 1.42, 1.43, 1.44, 1.45, 1.46, 1.47, 1.48, 1.49, 1.5,  &
       1.51, 1.52, 1.53, 1.54, 1.55, 1.56, 1.57, 1.58, 1.59, 1.6, 1.61, 1.62,  &
       1.63, 1.64, 1.65, 1.66, 1.67, 1.68, 1.69, 1.7, 1.71, 1.72, 1.73, 1.74,  &
       1.75, 1.76, 1.77, 1.78, 1.79, 1.8, 1.81, 1.82, 1.83, 1.84, 1.85, 1.86,  &
       1.87, 1.88, 1.89, 1.9, 1.91, 1.92, 1.93, 1.94, 1.95, 1.96, 1.97, 1.98,  &
       1.99, 2.0, 2.01, 2.02, 2.03, 2.04, 2.05, 2.06, 2.07, 2.08, 2.09, 2.1,  &
       2.11, 2.12, 2.13, 2.14, 2.15, 2.16, 2.17, 2.18, 2.19, 2.2, 2.21, 2.22,  &
       2.23, 2.24, 2.25, 2.26, 2.27, 2.28, 2.29, 2.3, 2.31, 2.32, 2.33, 2.34,  &
       2.35, 2.36, 2.37, 2.38, 2.39, 2.4, 2.41, 2.42, 2.43, 2.44, 2.45, 2.46,  &
       2.47, 2.48, 2.49, 2.5, 2.51, 2.52, 2.53, 2.54, 2.55, 2.56, 2.57, 2.58,  &
       2.59, 2.6, 2.61, 2.62, 2.63, 2.64, 2.65, 2.66, 2.67, 2.68, 2.69, 2.7,  &
       2.71, 2.72, 2.73, 2.74, 2.75, 2.76, 2.77, 2.78, 2.79, 2.8, 2.81, 2.82,  &
       2.83, 2.84, 2.85, 2.86, 2.87, 2.88, 2.89, 2.9, 2.91, 2.92, 2.93, 2.94,  &
       2.95, 2.96, 2.97, 2.98, 2.99, 3.0, 3.01, 3.02, 3.03, 3.04, 3.05, 3.06,  &
       3.07, 3.08, 3.09, 3.1, 3.11, 3.12, 3.13, 3.14, 3.15, 3.16, 3.17, 3.18,  &
       3.19, 3.2, 3.21, 3.22, 3.23, 3.24, 3.25, 3.26, 3.27, 3.28, 3.29, 3.3,  &
       3.31, 3.32, 3.33, 3.34, 3.35, 3.36, 3.37, 3.38, 3.39, 3.4, 3.41, 3.42,  &
       3.43, 3.44, 3.45, 3.46, 3.47, 3.48, 3.49, 3.5, 3.51, 3.52, 3.53, 3.54,  &
       3.55, 3.56, 3.57, 3.58, 3.59, 3.6, 3.61, 3.62, 3.63, 3.64, 3.65, 3.66,  &
       3.67, 3.68, 3.69, 3.7, 3.71, 3.72, 3.73, 3.74, 3.75, 3.76, 3.77, 3.78,  &
       3.79, 3.8, 3.81, 3.82, 3.83, 3.84, 3.85, 3.86, 3.87, 3.88, 3.89, 3.9,  &
       3.91, 3.92, 3.93, 3.94, 3.95, 3.96, 3.97, 3.98, 3.99, 4.0, 4.01, 4.02,  &
       4.03, 4.04, 4.05, 4.06, 4.07, 4.08, 4.09, 4.1, 4.11, 4.12, 4.13, 4.14,  &
       4.15, 4.16, 4.17, 4.18, 4.19, 4.2, 4.21, 4.22, 4.23, 4.24, 4.25, 4.26,  &
       4.27, 4.28, 4.29, 4.3, 4.31, 4.32, 4.33, 4.34, 4.35, 4.36, 4.37, 4.38,  &
       4.39, 4.4, 4.41, 4.42, 4.43, 4.44, 4.45, 4.46, 4.47, 4.48, 4.49, 4.5,  &
       4.51, 4.52, 4.53, 4.54, 4.55, 4.56, 4.57, 4.58, 4.59, 4.6, 4.61, 4.62,  &
       4.63, 4.64, 4.65, 4.66, 4.67, 4.68, 4.69, 4.7, 4.71, 4.72, 4.73, 4.74,  &
       4.75, 4.76, 4.77, 4.78, 4.79, 4.8, 4.81, 4.82, 4.83, 4.84, 4.85, 4.86,  &
       4.87, 4.88, 4.89, 4.9, 4.91, 4.92, 4.93, 4.94, 4.95, 4.96, 4.97, 4.98,  &
       4.99, 5.0, 5.01, 5.02, 5.03, 5.04, 5.05, 5.06, 5.07, 5.08, 5.09, 5.1,  &
       5.11, 5.12, 5.13, 5.14, 5.15, 5.16, 5.17, 5.18, 5.19, 5.2, 5.21, 5.22,  &
       5.23, 5.24, 5.25, 5.26, 5.27, 5.28, 5.29, 5.3, 5.31, 5.32, 5.33, 5.34,  &
       5.35, 5.36, 5.37, 5.38, 5.39, 5.4, 5.41, 5.42, 5.43, 5.44, 5.45, 5.46,  &
       5.47, 5.48, 5.49, 5.5, 5.51, 5.52, 5.53, 5.54, 5.55, 5.56, 5.57, 5.58,  &
       5.59, 5.6, 5.61, 5.62, 5.63, 5.64, 5.65, 5.66, 5.67, 5.68, 5.69, 5.7,  &
       5.71, 5.72, 5.73, 5.74, 5.75, 5.76, 5.77, 5.78, 5.79, 5.8, 5.81, 5.82,  &
       5.83, 5.84, 5.85, 5.86, 5.87, 5.88, 5.89, 5.9, 5.91, 5.92, 5.93, 5.94,  &
       5.95, 5.96, 5.97, 5.98, 5.99, 6.0, 6.01, 6.02, 6.03, 6.04, 6.05, 6.06,  &
       6.07, 6.08, 6.09, 6.1, 6.11, 6.12, 6.13, 6.14, 6.15, 6.16, 6.17, 6.18,  &
       6.19, 6.2, 6.21, 6.22, 6.23, 6.24, 6.25, 6.26, 6.27, 6.28, 6.29, 6.3,  &
       6.31, 6.32, 6.33, 6.34, 6.35, 6.36, 6.37, 6.38, 6.39, 6.4, 6.41, 6.42,  &
       6.43, 6.44, 6.45, 6.46, 6.47, 6.48, 6.49, 6.5, 6.51, 6.52, 6.53, 6.54,  &
       6.55, 6.56, 6.57, 6.58, 6.59, 6.6, 6.61, 6.62, 6.63, 6.64, 6.65, 6.66,  &
       6.67, 6.68, 6.69, 6.7, 6.71, 6.72, 6.73, 6.74, 6.75, 6.76, 6.77, 6.78,  &
       6.79, 6.8, 6.81, 6.82, 6.83, 6.84, 6.85, 6.86, 6.87, 6.88, 6.89, 6.9,  &
       6.91, 6.92, 6.93, 6.94, 6.95, 6.96, 6.97, 6.98, 6.99, 7.0, 7.01, 7.02,  &
       7.03, 7.04, 7.05, 7.06, 7.07, 7.08, 7.09, 7.1, 7.11, 7.12, 7.13, 7.14,  &
       7.15, 7.16, 7.17, 7.18, 7.19, 7.2, 7.21, 7.22, 7.23, 7.24, 7.25, 7.26,  &
       7.27, 7.28, 7.29, 7.3, 7.31, 7.32, 7.33, 7.34, 7.35, 7.36, 7.37, 7.38,  &
       7.39, 7.4, 7.41, 7.42, 7.43, 7.44, 7.45, 7.46, 7.47, 7.48, 7.49, 7.5,  &
       7.51, 7.52, 7.53, 7.54, 7.55, 7.56, 7.57, 7.58, 7.59, 7.6, 7.61, 7.62,  &
       7.63, 7.64, 7.65, 7.66, 7.67, 7.68, 7.69, 7.7, 7.71, 7.72, 7.73, 7.74,  &
       7.75, 7.76, 7.77, 7.78, 7.79, 7.8, 7.81, 7.82, 7.83, 7.84, 7.85, 7.86,  &
       7.87, 7.88, 7.89, 7.9, 7.91, 7.92, 7.93, 7.94, 7.95, 7.96, 7.97, 7.98,  &
       7.99, 8.0  &
   y = -266.5226561524, -265.7921684246, -265.0763121706, -264.3749668444,  &
       -263.6880169024, -263.0153514603, -262.3568639584, -261.7124518371,  &
       -261.0820162218, -260.4654616151, -259.8626955994, -259.2736285465,  &
       -258.6981733365, -258.1362450841, -257.5877608732, -257.0526394998,  &
       -256.5308012221, -256.0221675189, -255.5266608559, -255.0442044594,  &
       -254.5747220979, -254.1181378714, -253.674376009, -253.2433606733,  &
       -252.8250157736, -252.4192647868, -252.0260305398, -251.6452350932,  &
       -251.2767996089, -250.9206441743, -250.5766876633, -250.2448476033,  &
       -249.9250400514, -249.617179478, -249.3211786587, -249.0369485737,  &
       -248.7643983155, -248.5034350042, -248.2539637113, -248.0158873903,  &
       -247.7891068157, -247.5735205302, -247.3690247981, -247.1755135677,  &
       -246.99287844, -246.8210086458, -246.6597910288, -246.5091100369,  &
       -246.3688477193, -246.2388837317, -246.1190953468, -246.0093574718,  &
       -245.9095426725, -245.8195212028, -245.7391610404, -245.668327928,  &
       -245.6068854199, -245.554694934, -245.5116158086, -245.4775053637,  &
       -245.4522189673, -245.4356101056, -245.4275304569, -245.4278299699,  &
       -245.4363569449, -245.4529581188, -245.477478752, -245.5097627196,  &
       -245.5496526033, -245.5969897872, -245.6516145538, -245.7133661834,  &
       -245.7820835901, -245.8576035707, -245.939761038, -246.02839215,  &
       -246.1233325704, -246.2244175723, -246.3314821424, -246.4443610844,  &
       -246.5628891228, -246.6869010057, -246.8162316069, -246.9507160274,  &
       -247.0901896956, -247.234488145, -247.3834483215, -247.5369042522,  &
       -247.6947005438, -247.8566759031, -248.022669936, -248.1925232355,  &
       -248.3660774682, -248.5431754582, -248.7236629717, -248.9073835326,  &
       -249.0941795835, -249.2838992158, -249.4763920621, -249.6715093654,  &
       -249.8691040448, -250.0690307594, -250.2711432129, -250.4753028662,  &
       -250.6813730516, -250.8892170209, -251.098699326, -251.3096863774,  &
       -251.5220466871, -251.7356509082, -251.9503718724, -252.1660851418,  &
       -252.3826715368, -252.6000005328, -252.8179538593, -253.0364136597,  &
       -253.2552649926, -253.4744054667, -253.6937263487, -253.9131212922,  &
       -254.132485678, -254.3517191743, -254.5707230143, -254.7894004815,  &
       -255.0076572669, -255.2254014663, -255.442543575, -255.659000284,  &
       -255.8746734891, -256.089489558, -256.303368494, -256.5162326398,  &
       -256.7280066588, -256.9386175148, -257.1479943692, -257.3560680708,  &
       -257.5627740984, -257.7680483842, -257.9718290305, -258.1740498804,  &
       -258.3746643473, -258.5736233159, -258.77086794, -258.9663398354,  &
       -259.1599894328, -259.3517690861, -259.5416330327, -259.7295373511,  &
       -259.9154399187, -260.0992995332, -260.2810731649, -260.4607354519,  &
       -260.6382531677, -260.8135924943, -260.9867211284, -261.1576119679,  &
       -261.3262297978, -261.4925407394, -261.6565180993, -261.8181364561,  &
       -261.9773716091, -262.1341946527, -262.2885964534, -262.4405558517,  &
       -262.5900547231, -262.7370741109, -262.8815959583, -263.0236030565,  &
       -263.1630789915, -263.3000106495, -263.434379632, -263.566164806,  &
       -263.6953477368, -263.8219270185, -263.9458901016, -264.067224684,  &
       -264.1859188429, -264.301960587, -264.4153394286, -264.5260447546,  &
       -264.6340656404, -264.7393912915, -264.8420109958, -264.9419112476,  &
       -265.0390899819, -265.1335339469, -265.2252286123, -265.3141629756,  &
       -265.4003258405, -265.483705773, -265.5642910586, -265.6420696606,  &
       -265.7170291439, -265.7891565189, -265.8584395327, -265.9248627899,  &
       -265.9884160969, -266.0490872734, -266.1068607315, -266.1617202525,  &
       -266.2136494368, -266.2626303028, -266.3086398624, -266.3516591975,  &
       -266.3916685972, -266.4286475278, -266.4625746034, -266.4934275577,  &
       -266.5211829911, -266.5458168141, -266.5673080735, -266.5856307192,  &
       -266.6007579244, -266.6126614047, -266.6213118221, -266.6266787628,  &
       -266.628730717, -266.6274350591, -266.6227580278, -266.6146647083,  &
       -266.6031195777, -266.5880827931, -266.5695143261, -266.5473746632,  &
       -266.5216229434, -266.4922176147, -266.4591174358, -266.422277718,  &
       -266.3816524833, -266.3371944518, -266.288855031, -266.2365843046,  &
       -266.1803310224, -266.1200425908, -266.0556650688, -265.987143359,  &
       -265.9144207788, -265.83743926, -265.7561393509, -265.6704602102,  &
       -265.5803396008, -265.4857138846, -265.3865180177, -265.2826855458,  &
       -265.1741486006, -265.060837897, -264.9426827297, -264.8196109902,  &
       -264.6915497966, -264.5584242571, -264.4201578999, -264.2766728333,  &
       -264.1278897467, -263.9737279134, -263.8141051929, -263.6489380354,  &
       -263.4781414857, -263.3016291897, -263.1193134005, -262.9311049864,  &
       -262.7369134396, -262.5366468862, -262.3302120976, -262.1175145032,  &
       -261.898458204, -261.6729459885, -261.4408793492, -261.2021585018,  &
       -260.9566824051, -260.7043487834, -260.4450541505, -260.1786938358,  &
       -259.9051620125, -259.6243517277, -259.3361549356, -259.040462532,  &
       -258.7371643922, -258.4261494113, -258.1073055467, -257.7805198644,  &
       -257.4456785876, -257.1026671482, -256.7513702422, -256.3916718879,  &
       -256.0234554874, -255.6466038922, -255.2609994717, -254.8665241859,  &
       -254.4630596621, -254.0504872749, -253.6286882308, -253.1975436569,  &
       -252.7569346934, -252.3067425909, -251.8468488121, -251.3771351371,  &
       -250.8974837747, -250.4077774769, -249.9078996586, -249.3977345222,  &
       -248.8771671865, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864, -248.8771671864, -248.8771671864, -248.8771671864,  &
       -248.8771671864  &
   linear_extrapolate = no
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_1  &
   adams_id = 55  &
   closed = no  &
   tension = 5.0E-02  &
   matrix_name = .Flap_Mechanism.MATRIX_1  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_56  &
   adams_id = 61  &
   closed = no  &
   tension = 5.0E-02  &
   matrix_name = .Flap_Mechanism.MATRIX_55  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_62  &
   adams_id = 88  &
   closed = no  &
   tension = 5.0E-02  &
   matrix_name = .Flap_Mechanism.MATRIX_61  &
   fit_type = curve_points  &
   interpolation_order = 4
!
data_element create curve  &
   curve_name = .Flap_Mechanism.CURVE_95  &
   adams_id = 97  &
   closed = no  &
   tension = 5.0E-02  &
   matrix_name = .Flap_Mechanism.MATRIX_94  &
   fit_type = curve_points  &
   interpolation_order = 4
!
!-------------------------------- Rigid Parts ---------------------------------!
!
! Create parts and their dependent markers and graphics
!
!---------------------------------- Airframe ----------------------------------!
!
!
! ****** Ground Part ******
!
part modify rigid_body name_and_position  &
   part_name = ground  &
   new_part_name = Airframe
!
defaults model  &
   part_name = Airframe
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra2_SHELL  &
   adams_id = 190  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra2_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra3_SHELL  &
   adams_id = 191  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra3_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   adams_id = 56  &
   location = 11.45525407, -1.12395, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   adams_id = 62  &
   location = 11.45525407, -3.6322, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   adams_id = 89  &
   location = 11.58493086, -1.12395, 1.11785473  &
   orientation = 180.0d, 90.0d, 168.8237873d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   adams_id = 92  &
   location = 11.45525407, -1.14935, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   adams_id = 95  &
   location = 11.45525407, -3.6068, 1.270000419  &
   orientation = 180.0d, 90.0d, 180.6227138d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   adams_id = 98  &
   location = 11.58493086, -3.6322, 1.11785473  &
   orientation = 180.0d, 90.0d, 168.8237873d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.sph_in_motor  &
   adams_id = 153  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.sph_in_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf1  &
   adams_id = 166  &
   location = 12.184126, -3.584575, 1.1568938  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf1  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf2  &
   adams_id = 167  &
   location = 12.184126, -3.101975, 1.1574272  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf2  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf3  &
   adams_id = 168  &
   location = 12.184126, -2.619375, 1.157986  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf3  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf4  &
   adams_id = 169  &
   location = 12.184126, -2.136775, 1.1585194  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf4  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf5  &
   adams_id = 170  &
   location = 12.184126, -1.654175, 1.1590782  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf5  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.jsf6  &
   adams_id = 171  &
   location = 12.184126, -1.171575, 1.15951  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.jsf6  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.sph_out_motor  &
   adams_id = 185  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.sph_out_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra4_SHELL  &
   adams_id = 192  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra4_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra5_SHELL  &
   adams_id = 193  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra5_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra6_SHELL  &
   adams_id = 194  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra6_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra7_SHELL  &
   adams_id = 195  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra7_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.gra1_SHELL  &
   adams_id = 220  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.gra1_SHELL  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Airframe.rev_spoiler  &
   adams_id = 222  &
   location = 11.460226, -1.14935, 1.302930846  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Airframe.rev_spoiler  &
   visibility = off
!
! ****** Floating Markers for current part ******
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.Float_inslif_ptcv  &
   adams_id = 58
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_outf_ptcv  &
   adams_id = 64
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_in_bot_roller_ptcv  &
   adams_id = 100
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_inslir_ptcv  &
   adams_id = 102
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_outr_ptcv  &
   adams_id = 104
!
floating_marker create  &
   floating_marker_name = .Flap_Mechanism.Airframe.float_out_bot_roller_ptcv  &
   adams_id = 106
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL39  &
   reference_marker = .Flap_Mechanism.Airframe.gra2_SHELL  &
   file_name = "./cad/Airframe_39.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL39  &
   color = RED  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL40  &
   reference_marker = .Flap_Mechanism.Airframe.gra3_SHELL  &
   file_name = "./cad/Airframe_40.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL40  &
   color = RED  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL41  &
   reference_marker = .Flap_Mechanism.Airframe.gra4_SHELL  &
   file_name = "./cad/Airframe_41.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL41  &
   color = DDM_41  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL42  &
   reference_marker = .Flap_Mechanism.Airframe.gra5_SHELL  &
   file_name = "./cad/Airframe_42.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL42  &
   color = BLUE  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL43  &
   reference_marker = .Flap_Mechanism.Airframe.gra6_SHELL  &
   file_name = "./cad/Airframe_43.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL43  &
   color = DDM_43  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.SHELL44  &
   reference_marker = .Flap_Mechanism.Airframe.gra7_SHELL  &
   file_name = "./cad/Airframe_44.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.SHELL44  &
   color = BLUE  &
   visibility = on
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Airframe.part1  &
   reference_marker = .Flap_Mechanism.Airframe.gra1_SHELL  &
   file_name = "./cad/Airframe.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Airframe.part1  &
   color = SILVER  &
   visibility = off
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.insli_curve  &
   adams_id = 1  &
   ref_curve_name = .Flap_Mechanism.CURVE_1  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.outsli_curve  &
   adams_id = 2  &
   ref_curve_name = .Flap_Mechanism.CURVE_56  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.inbot_curve  &
   adams_id = 3  &
   ref_curve_name = .Flap_Mechanism.CURVE_62  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv
!
geometry create curve bspline  &
   bspline_name = .Flap_Mechanism.Airframe.outbot_curve  &
   adams_id = 4  &
   ref_curve_name = .Flap_Mechanism.CURVE_95  &
   segment_count = 200  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv
!
part attributes  &
   part_name = .Flap_Mechanism.Airframe  &
   visibility = on  &
   size_of_icons = 0.1
!
!--------------------------- outside_bottom_roller ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   adams_id = 2  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_bottom_roller
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.cm  &
   adams_id = 3  &
   location = 11.5824, -3.616325, 1.1303  &
   orientation = 90.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   adams_id = 83  &
   location = 11.58493086, -3.6322, 1.11785473  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   adams_id = 111  &
   location = 11.5824, -3.60045, 1.1303  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   adams_id = 196  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   mass = 1.608796247E-02  &
   center_of_mass_marker = .Flap_Mechanism.outside_bottom_roller.cm  &
   ixx = 1.2974137322E-06  &
   iyy = 2.0001795048E-06  &
   izz = 2.0001795048E-06  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_bottom_roller.SHELL45  &
   reference_marker = .Flap_Mechanism.outside_bottom_roller.gra_SHELL  &
   file_name = "./cad/outside_bottom_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_bottom_roller.SHELL45  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.outside_bottom_roller  &
   size_of_icons = 0.1
!
!------------------------------- outside_slider -------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_slider  &
   adams_id = 14  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_slider
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   adams_id = 59  &
   location = 11.47112857, -3.6322, 1.269875917  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.graf_SHELL  &
   adams_id = 197  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.graf_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.cm  &
   adams_id = 15  &
   location = 11.6299452811, -3.5980610994, 1.2601725843  &
   orientation = 90.5728924891d, 98.3548666176d, 6.0532139837d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   adams_id = 188  &
   location = 11.7602, -3.603625, 1.2192  &
   orientation = 180.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.gra_SHELL  &
   adams_id = 198  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   adams_id = 84  &
   location = 11.72420758, -3.6068, 1.25888203  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_slider.grar_SHELL  &
   adams_id = 199  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_slider.grar_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_slider  &
   mass = 0.3141884872  &
   center_of_mass_marker = .Flap_Mechanism.outside_slider.cm  &
   ixx = 2.6935637889E-03  &
   iyy = 2.6064731318E-03  &
   izz = 1.3114327886E-04  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL48  &
   reference_marker = .Flap_Mechanism.outside_slider.gra_SHELL  &
   file_name = "./cad/outside_slider.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL48  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL47  &
   reference_marker = .Flap_Mechanism.outside_slider.graf_SHELL  &
   file_name = "./cad/outside_slider_front_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL47  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_slider.SHELL49  &
   reference_marker = .Flap_Mechanism.outside_slider.grar_SHELL  &
   file_name = "./cad/outside_slider_rear_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_slider.SHELL49  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.outside_slider  &
   size_of_icons = 0.1
!
!---------------------------- inside_bottom_roller ----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   adams_id = 22  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_bottom_roller
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.cm  &
   adams_id = 23  &
   location = 11.5824, -1.139825, 1.1303  &
   orientation = 90.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   adams_id = 45  &
   location = 11.5824, -1.1557, 1.1303  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   adams_id = 85  &
   location = 11.58493086, -1.12395, 1.11785473  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   adams_id = 200  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   mass = 1.608796247E-02  &
   center_of_mass_marker = .Flap_Mechanism.inside_bottom_roller.cm  &
   ixx = 1.2974137332E-06  &
   iyy = 2.0001795048E-06  &
   izz = 2.0001795048E-06  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_bottom_roller.SHELL50  &
   reference_marker = .Flap_Mechanism.inside_bottom_roller.gra_SHELL  &
   file_name = "./cad/inside_bottom_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_bottom_roller.SHELL50  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.inside_bottom_roller  &
   size_of_icons = 0.1
!
!------------------------------- inside_slider --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_slider  &
   adams_id = 28  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_slider
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   adams_id = 53  &
   location = 11.47112857, -1.12395, 1.269875917  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.graf_SHELL  &
   adams_id = 201  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.graf_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.cm  &
   adams_id = 29  &
   location = 11.6299388639, -1.1580884178, 1.2601667757  &
   orientation = 89.4271215254d, 98.3566144656d, 353.9403873146d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   adams_id = 32  &
   location = 11.7602, -1.152525, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.gra_SHELL  &
   adams_id = 202  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   adams_id = 86  &
   location = 11.72420758, -1.14935, 1.25888203  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_slider.grar_SHELL  &
   adams_id = 203  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_slider.grar_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_slider  &
   mass = 0.314124591  &
   center_of_mass_marker = .Flap_Mechanism.inside_slider.cm  &
   ixx = 2.6931540356E-03  &
   iyy = 2.6061305134E-03  &
   izz = 1.3107021338E-04  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL52  &
   reference_marker = .Flap_Mechanism.inside_slider.gra_SHELL  &
   file_name = "./cad/inside_slider.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL52  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL51  &
   reference_marker = .Flap_Mechanism.inside_slider.graf_SHELL  &
   file_name = "./cad/inside_slider_front_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL51  &
   color = YELLOW
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_slider.SHELL53  &
   reference_marker = .Flap_Mechanism.inside_slider.grar_SHELL  &
   file_name = "./cad/inside_slider_rear_roller.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_slider.SHELL53  &
   color = YELLOW
!
part attributes  &
   part_name = .Flap_Mechanism.inside_slider  &
   size_of_icons = 0.1
!
!---------------------------- outside_drive_motor -----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   adams_id = 115  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_drive_motor
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.cm  &
   adams_id = 116  &
   location = 11.71360964, -3.051175, 1.222376615  &
   orientation = 180.0d, 90.0d, 183.9004937d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   adams_id = 140  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   adams_id = 184  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   adams_id = 204  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   adams_id = 225  &
   location = 11.4808, -3.051, 1.23825  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   adams_id = 231  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   mass = 1.3417624135  &
   center_of_mass_marker = .Flap_Mechanism.outside_drive_motor.cm  &
   ixx = 9.4936474808E-04  &
   iyy = 6.394713254E-02  &
   izz = 6.3947609402E-02  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_drive_motor.SHELL54  &
   reference_marker = .Flap_Mechanism.outside_drive_motor.gra_SHELL  &
   file_name = "./cad/outside_drive_motor.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_drive_motor.SHELL54  &
   color = DDM_54
!
part attributes  &
   part_name = .Flap_Mechanism.outside_drive_motor  &
   size_of_icons = 0.1
!
!----------------------------- outside_drive_eye ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   adams_id = 119  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.outside_drive_eye
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.cm  &
   adams_id = 120  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90009816d, 180.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   adams_id = 141  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   adams_id = 180  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 270.0d, 89.67080993d, 90.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   adams_id = 205  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   adams_id = 224  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   adams_id = 230  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 89.9641132423d, 93.9004929797d, 269.9975588434d
!
marker attributes  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   visibility = on
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   mass = 8.293433075E-02  &
   center_of_mass_marker = .Flap_Mechanism.outside_drive_eye.cm  &
   ixx = 2.8822753573E-05  &
   iyy = 5.8148617287E-05  &
   izz = 5.8748545314E-05  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.outside_drive_eye.SHELL55  &
   reference_marker = .Flap_Mechanism.outside_drive_eye.gra_SHELL  &
   file_name = "./cad/outside_drive_eye.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.outside_drive_eye.SHELL55  &
   color = DDM_55
!
part attributes  &
   part_name = .Flap_Mechanism.outside_drive_eye  &
   size_of_icons = 0.1
!
!----------------------------- inside_drive_motor -----------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   adams_id = 123  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_drive_motor
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.cm  &
   adams_id = 124  &
   location = 11.71360964, -1.704975, 1.222376615  &
   orientation = 180.0d, 89.99999988d, 183.9004937d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_eye  &
   adams_id = 142  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_eye  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   adams_id = 151  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   adams_id = 206  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   adams_id = 227  &
   location = 11.4808, -1.704975, 1.23825  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   adams_id = 229  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor  &
   adams_id = 247  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor  &
   visibility = on  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor_2  &
   adams_id = 248  &
   location = 11.7502231631, -1.704975, 1.2198802389  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor_2  &
   visibility = on  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   mass = 1.3417624135  &
   center_of_mass_marker = .Flap_Mechanism.inside_drive_motor.cm  &
   ixx = 9.4936474808E-04  &
   iyy = 6.394713254E-02  &
   izz = 6.3947609402E-02  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_drive_motor.SHELL56  &
   reference_marker = .Flap_Mechanism.inside_drive_motor.gra_SHELL  &
   file_name = "./cad/inside_drive_motor.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_drive_motor.SHELL56  &
   color = DDM_56
!
part attributes  &
   part_name = .Flap_Mechanism.inside_drive_motor  &
   size_of_icons = 0.1
!
!------------------------------ inside_drive_eye ------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   adams_id = 127  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.inside_drive_eye
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.cm  &
   adams_id = 128  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90009808d, 180.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.cm  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   adams_id = 129  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 90.0d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   adams_id = 143  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   adams_id = 207  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   visibility = off  &
   size_of_icons = 0.1
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   adams_id = 226  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   adams_id = 228  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.9004937424d, 270.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   visibility = on
!
marker create  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_eye  &
   adams_id = 246  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 90.0d, 93.90049374d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.inside_drive_eye.tr_eye  &
   visibility = off  &
   size_of_icons = 0.1
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   mass = 8.293433075E-02  &
   center_of_mass_marker = .Flap_Mechanism.inside_drive_eye.cm  &
   ixx = 2.8822753568E-05  &
   iyy = 5.8148617287E-05  &
   izz = 5.8748545314E-05  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.inside_drive_eye.SHELL57  &
   reference_marker = .Flap_Mechanism.inside_drive_eye.gra_SHELL  &
   file_name = "./cad/inside_drive_eye.shl"  &
   wireframe_only = no
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.inside_drive_eye.SHELL57  &
   color = DDM_57
!
part attributes  &
   part_name = .Flap_Mechanism.inside_drive_eye  &
   size_of_icons = 0.1
!
!-------------------------------- Left_Spoiler --------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   adams_id = 128  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Left_Spoiler
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Left_Spoiler.PSMAR  &
   adams_id = 223  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Left_Spoiler.PSMAR  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   adams_id = 221  &
   location = 11.460226, -1.14935, 1.302930846  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   visibility = off
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   mass = 10.0  &
   center_of_mass_marker = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   ixx = 1.0  &
   iyy = 1.0  &
   izz = 1.0  &
   ixy = 0.0  &
   izx = 0.0  &
   iyz = 0.0
!
! ****** Graphics for current part ******
!
part attributes  &
   part_name = .Flap_Mechanism.Left_Spoiler  &
   color = YELLOW
!
!--------------------------------- Rigid_flap ---------------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
part create rigid_body name_and_position  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   adams_id = 129  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Rigid_flap
!
! ****** Markers for current part ******
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.gra  &
   adams_id = 232  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.gra  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cm  &
   adams_id = 233  &
   location = 12.0166125647, -2.3786868552, 1.1780506871  &
   orientation = 274.191697221d, 2.4985865457d, 85.7694819124d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.cm  &
   color = RED
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cyl_inslider  &
   adams_id = 234  &
   location = 11.7602, -1.152525, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.tr_in_bot_rol  &
   adams_id = 235  &
   location = 11.5824, -1.1557, 1.1303  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.uni_in_eye  &
   adams_id = 236  &
   location = 11.7602, -1.704975, 1.2192  &
   orientation = 0.0d, 90.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.fix_out_bot_rol  &
   adams_id = 237  &
   location = 11.5824, -3.60045, 1.1303  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf1  &
   adams_id = 238  &
   location = 12.184126, -3.584575, 1.1568938  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf1  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf2  &
   adams_id = 239  &
   location = 12.184126, -3.101975, 1.1574272  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf2  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf3  &
   adams_id = 240  &
   location = 12.184126, -2.619375, 1.157986  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf3  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf4  &
   adams_id = 241  &
   location = 12.184126, -2.136775, 1.1585194  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf4  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf5  &
   adams_id = 242  &
   location = 12.184126, -1.654175, 1.1590782  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf5  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf6  &
   adams_id = 243  &
   location = 12.184126, -1.171575, 1.15951  &
   orientation = 0.0d, 0.0d, 0.0d
!
marker attributes  &
   marker_name = .Flap_Mechanism.Rigid_flap.isf6  &
   visibility = off
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.uni_out_eye  &
   adams_id = 244  &
   location = 11.7602, -3.051175, 1.2192  &
   orientation = 0.0d, 90.0d, 179.6708099d
!
marker create  &
   marker_name = .Flap_Mechanism.Rigid_flap.cyl_outslider  &
   adams_id = 245  &
   location = 11.7602, -3.603625, 1.2192  &
   orientation = 180.0d, 90.0d, 0.0d
!
part create rigid_body mass_properties  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   mass = 58.0722748374  &
   center_of_mass_marker = .Flap_Mechanism.Rigid_flap.cm  &
   ixx = 29.9283945977  &
   iyy = 5.1007175215  &
   izz = 34.7503519596  &
   ixy = 1.44173341E-02  &
   izx = 0.2094988836  &
   iyz = 9.519489288E-02
!
! ****** Graphics for current part ******
!
geometry create shape shell  &
   shell_name = .Flap_Mechanism.Rigid_flap.SHL6722  &
   reference_marker = .Flap_Mechanism.Rigid_flap.gra  &
   file_name = "./cad/Rigidflap.shl"  &
   wireframe_only = no
!
part attributes  &
   part_name = .Flap_Mechanism.Rigid_flap  &
   color = GREEN
!
! ****** Graphics from Parasolid file ******
!
file parasolid read  &
   file_name = "Controls_Plant_1.x_t"  &
   model_name = .Flap_Mechanism
!
geometry attributes  &
   geometry_name = .Flap_Mechanism.Left_Spoiler.SOLID20  &
   color = SlateBlue  &
   transparency = 40
!
!---------------------------- Higher pair contacts ----------------------------!
!
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.inslif_PointCurve  &
   adams_id = 57  &
   i_marker_name = .Flap_Mechanism.inside_slider.ptcv_front  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.Float_inslif_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslif_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_1
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.inslif_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.outf_PointCurve  &
   adams_id = 63  &
   i_marker_name = .Flap_Mechanism.outside_slider.ptcv_front  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_outf_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outf_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_56
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.outf_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.in_bot_roller_pointcurve  &
   adams_id = 99  &
   i_marker_name = .Flap_Mechanism.inside_bottom_roller.iptcv  &
   j_floating_marker_name =   &
                            .Flap_Mechanism.Airframe.float_in_bot_roller_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_in_bot_roller_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_62
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.in_bot_roller_pointcurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.inslir_PointCurve  &
   adams_id = 101  &
   i_marker_name = .Flap_Mechanism.inside_slider.ptcv_rear  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_inslir_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_inslir_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_1
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.inslir_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.outr_PointCurve  &
   adams_id = 103  &
   i_marker_name = .Flap_Mechanism.outside_slider.ptcv_rear  &
   j_floating_marker_name = .Flap_Mechanism.Airframe.float_outr_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_outr_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_56
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.outr_PointCurve  &
   size_of_icons = 0.1
!
constraint create higher_pair_contact point_curve  &
   point_curve_name = .Flap_Mechanism.out_bot_roller_PointCurve  &
   adams_id = 105  &
   i_marker_name = .Flap_Mechanism.outside_bottom_roller.iptcv  &
   j_floating_marker_name =   &
                            .Flap_Mechanism.Airframe.float_out_bot_roller_ptcv  &
   ref_marker_name = .Flap_Mechanism.Airframe.ref_out_bot_roller_ptcv  &
   curve_name = .Flap_Mechanism.CURVE_95
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.out_bot_roller_PointCurve  &
   size_of_icons = 0.1
!
!----------------------------------- Joints -----------------------------------!
!
!
constraint create joint cylindrical  &
   joint_name = .Flap_Mechanism.flap_inslider  &
   adams_id = 43  &
   i_marker_name = .Flap_Mechanism.inside_slider.cyl_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.cyl_inslider
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_inslider  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.flap_in_bot_roller  &
   adams_id = 52  &
   i_marker_name = .Flap_Mechanism.inside_bottom_roller.tr_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.tr_in_bot_rol
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_in_bot_roller  &
   size_of_icons = 0.1
!
constraint create joint universal  &
   joint_name = .Flap_Mechanism.flap_in_eye  &
   adams_id = 137  &
   i_marker_name = .Flap_Mechanism.inside_drive_eye.uni_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.uni_in_eye
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_in_eye  &
   size_of_icons = 0.1
!
constraint create joint fixed  &
   joint_name = .Flap_Mechanism.flap_out_bot_roller  &
   adams_id = 139  &
   i_marker_name = .Flap_Mechanism.outside_bottom_roller.fix_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.fix_out_bot_rol
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_out_bot_roller  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.out_motor_eye  &
   adams_id = 144  &
   i_marker_name = .Flap_Mechanism.outside_drive_motor.tr_eye  &
   j_marker_name = .Flap_Mechanism.outside_drive_eye.tr_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.out_motor_eye  &
   size_of_icons = 0.1
!
constraint create joint translational  &
   joint_name = .Flap_Mechanism.in_motor_eye  &
   adams_id = 145  &
   i_marker_name = .Flap_Mechanism.inside_drive_eye.tr_eye  &
   j_marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.in_motor_eye  &
   size_of_icons = 0.1
!
constraint create joint spherical  &
   joint_name = .Flap_Mechanism.airframe_in_motor  &
   adams_id = 155  &
   i_marker_name = .Flap_Mechanism.inside_drive_motor.sph_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.sph_in_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.airframe_in_motor  &
   size_of_icons = 0.1
!
constraint create joint universal  &
   joint_name = .Flap_Mechanism.flap_out_eye  &
   adams_id = 183  &
   i_marker_name = .Flap_Mechanism.outside_drive_eye.uni_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.uni_out_eye
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_out_eye  &
   size_of_icons = 0.1
!
constraint create joint spherical  &
   joint_name = .Flap_Mechanism.airframe_out_motor  &
   adams_id = 186  &
   i_marker_name = .Flap_Mechanism.outside_drive_motor.sph_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.sph_out_motor
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.airframe_out_motor  &
   size_of_icons = 0.1
!
constraint create joint cylindrical  &
   joint_name = .Flap_Mechanism.flap_outslider  &
   adams_id = 189  &
   i_marker_name = .Flap_Mechanism.outside_slider.cyl_flap  &
   j_marker_name = .Flap_Mechanism.Rigid_flap.cyl_outslider
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.flap_outslider  &
   size_of_icons = 0.1
!
constraint create joint revolute  &
   joint_name = .Flap_Mechanism.Revolute_Spoiler  &
   adams_id = 190  &
   i_marker_name = .Flap_Mechanism.Left_Spoiler.rev_airframe  &
   j_marker_name = .Flap_Mechanism.Airframe.rev_spoiler
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.Revolute_Spoiler  &
   name_visibility = off
!
!----------------------------------- Forces -----------------------------------!
!
!
force create direct single_component_force  &
   single_component_force_name = .Flap_Mechanism.SFORCE_1  &
   adams_id = 1  &
   type_of_freedom = translational  &
   i_marker_name = .Flap_Mechanism.inside_drive_eye.tr_eye  &
   j_marker_name = .Flap_Mechanism.inside_drive_motor.tr_motor_2  &
   action_only = on  &
   function = ""
!
!----------------------------- Simulation Scripts -----------------------------!
!
!
simulation script create  &
   sim_script_name = .Flap_Mechanism.SIM_KIN  &
   type = auto_select  &
   initial_static = no  &
   number_of_steps = 800  &
   end_time = 8.0
!
simulation script create  &
   sim_script_name = .Flap_Mechanism.SIM_KIN_FAILURE  &
   solver_commands = "! Insert ACF commands here:", "OUTPUT/NOSEPARATOR",  &
                     "SIMULATE/KINEMATIC, END=1.0, STEPS=100",  &
                     "DEACTIVATE/MOTION, ID=158",  &
                     "SIMULATE/KINEMATIC, DURATION=7.0, STEPS=700"
!
simulation script create  &
   sim_script_name = .Flap_Mechanism.Last_Sim  &
   commands = "simulation single_run equilibrium model_name=.Flap_Mechanism"
!
!-------------------------- Adams View UDE Instances --------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
undo begin_block suppress = yes
!
ude create instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler  &
   definition_name = .MDI.Constraints.general_motion  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
ude create instance  &
   instance_name = .Flap_Mechanism.Controls_Plant_1  &
   definition_name = .controls.controls_plant  &
   location = 0.0, 0.0, 0.0  &
   orientation = 0.0, 0.0, 0.0
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.i_marker  &
   object_value = (.Flap_Mechanism.Left_Spoiler.rev_airframe)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.j_marker  &
   object_value = (.Flap_Mechanism.Airframe.rev_spoiler)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.constraint  &
   object_value = (.Flap_Mechanism.Revolute_Spoiler)
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_type  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_type  &
   integer_value = 1
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_func  &
   string_value = "0 * time"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_func  &
   string_value = "DTOR*(
45*STEP5(TIME,5,0,7,1)
)"
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_ic_disp  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t1_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t2_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.t3_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r1_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r2_ic_velo  &
   real_value = 0.0
!
variable modify  &
   variable_name = .Flap_Mechanism.Mot_spoiler.r3_ic_velo  &
   real_value = 0.0
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.input_channels  &
   object_value = .Flap_Mechanism.Input_force
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.output_channels  &
   object_value =   &
      .Flap_Mechanism.spostamento,  &
      .Flap_Mechanism.speed
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.file_name  &
   string_value = "Controls_Plant_1"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.event_name  &
   string_value = ""
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.solver_type  &
   string_value = "cplusplus"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.target  &
   string_value = "FMUv2_0"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.FMI_Master  &
   string_value = "none"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.analysis_type  &
   string_value = "non_linear"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.analysis_init  &
   string_value = "no"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.analysis_init_str  &
   string_value = ""
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.user_lib  &
   string_value = ""
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.host  &
   string_value = "LGG3HZW2.na.mscsoftware.com"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.dynamic_state  &
   string_value = "on"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.tcp_ip  &
   string_value = "off"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.output_rate  &
   integer_value = 1
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.realtime  &
   string_value = "off"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.include_mnf  &
   string_value = "no"
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.hp_group  &
   object_value = (NONE)
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.pv_group  &
   object_value = (NONE)
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.gp_group  &
   object_value = (NONE)
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.pf_group  &
   object_value = (NONE)
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.ude_group  &
   object_value = (NONE)
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.expose_variant  &
   integer_value = 0
!
variable modify  &
   variable_name = .Flap_Mechanism.Controls_Plant_1.expose_event  &
   integer_value = 0
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Controls_Plant_1
!
undo end_block
!
!---------------------------------- Motions -----------------------------------!
!
!
constraint create motion_generator  &
   motion_name = .Flap_Mechanism.MOT_OUT_ACT  &
   adams_id = 158  &
   type_of_freedom = translational  &
   joint_name = .Flap_Mechanism.out_motor_eye  &
   function = ""
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.MOT_OUT_ACT  &
   active = off  &
   color = YELLOW  &
   size_of_icons = 0.4
!
constraint create motion_generator  &
   motion_name = .Flap_Mechanism.MOT_IN_ACT  &
   adams_id = 159  &
   type_of_freedom = translational  &
   joint_name = .Flap_Mechanism.in_motor_eye  &
   function = ""
!
constraint attributes  &
   constraint_name = .Flap_Mechanism.MOT_IN_ACT  &
   active = off  &
   color = YELLOW  &
   size_of_icons = 0.4
!
!---------------------------------- Accgrav -----------------------------------!
!
!
force create body gravitational  &
   gravity_field_name = ACC  &
   x_component_gravity = 0.0  &
   y_component_gravity = 0.0  &
   z_component_gravity = -9.80665
!
force attributes  &
   force_name = .Flap_Mechanism.ACC  &
   size_of_icons = 0.1
!
!----------------------------- Analysis settings ------------------------------!
!
!
executive_control set numerical_integration_parameters  &
   model_name = Flap_Mechanism  &
   integrator_type = hht  &
   error_tolerance = 1.0E-06  &
   pattern_for_jacobian = no  &
   hinit_time_step = 1.0E-05  &
   corrector = modified
!
output_control set output  &
   model_name = Flap_Mechanism  &
   separator = off
!
output_control set results  &
   model_name = Flap_Mechanism  &
   formatted = on
!
!---------------------------------- Measures ----------------------------------!
!
!
measure create object  &
   measure_name = .Flap_Mechanism.in_motor_eye_d  &
   from_first = no  &
   object = .Flap_Mechanism.in_motor_eye  &
   coordinate_rframe = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.in_motor_eye_d  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.out_motor_eye_d  &
   from_first = no  &
   object = .Flap_Mechanism.out_motor_eye  &
   coordinate_rframe = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   characteristic = translational_displacement  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.out_motor_eye_d  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.in_motor_eye_v  &
   from_first = no  &
   object = .Flap_Mechanism.in_motor_eye  &
   coordinate_rframe = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.in_motor_eye_v  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.out_motor_eye_v  &
   from_first = no  &
   object = .Flap_Mechanism.out_motor_eye  &
   coordinate_rframe = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   characteristic = translational_velocity  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.out_motor_eye_v  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.MOT_IN_ACT_f  &
   from_first = yes  &
   object = .Flap_Mechanism.MOT_IN_ACT  &
   coordinate_rframe = .Flap_Mechanism.inside_drive_eye.tr_motor  &
   characteristic = element_force  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.MOT_IN_ACT_f  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.MOT_OUT_ACT_f  &
   from_first = yes  &
   object = .Flap_Mechanism.MOT_OUT_ACT  &
   coordinate_rframe = .Flap_Mechanism.outside_drive_eye.tr_motor  &
   characteristic = element_force  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.MOT_OUT_ACT_f  &
   active = off  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.Rigid_flap_dx  &
   from_first = no  &
   object = .Flap_Mechanism.Rigid_flap  &
   characteristic = cm_position  &
   component = x_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.Rigid_flap_dx  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.Rigid_flap_dy  &
   from_first = no  &
   object = .Flap_Mechanism.Rigid_flap  &
   characteristic = cm_position  &
   component = y_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.Rigid_flap_dy  &
   color = WHITE
!
measure create object  &
   measure_name = .Flap_Mechanism.Rigid_flap_dz  &
   from_first = no  &
   object = .Flap_Mechanism.Rigid_flap  &
   characteristic = cm_position  &
   component = z_component  &
   create_measure_display = no
!
data_element attributes  &
   data_element_name = .Flap_Mechanism.Rigid_flap_dz  &
   color = WHITE
!
!---------------------------- Adams View Variables ----------------------------!
!
!
variable create  &
   variable_name = .Flap_Mechanism.cpfiles  &
   integer_value = 1
!
variable create  &
   variable_name = .Flap_Mechanism.renfiles  &
   integer_value = 0
!
!---------------------------- Function definitions ----------------------------!
!
!
constraint modify motion_generator  &
   motion_name = .Flap_Mechanism.MOT_OUT_ACT  &
   function = "STEP5(TIME,0,0,3,-0.44)"
!
constraint modify motion_generator  &
   motion_name = .Flap_Mechanism.MOT_IN_ACT  &
   function = "STEP5(TIME,0,0,3,0.44)"
!
data_element modify variable  &
   variable_name = .Flap_Mechanism.Input_force  &
   function = "0"
!
data_element modify variable  &
   variable_name = .Flap_Mechanism.spostamento  &
   function = "DZ(.Flap_Mechanism.inside_drive_eye.tr_eye, .Flap_Mechanism.inside_drive_motor.tr_motor, .Flap_Mechanism.inside_drive_motor.tr_motor)"
!
data_element modify variable  &
   variable_name = .Flap_Mechanism.speed  &
   function = "VZ(.Flap_Mechanism.inside_drive_eye.tr_eye, .Flap_Mechanism.inside_drive_motor.tr_motor, .Flap_Mechanism.inside_drive_motor.tr_motor)"
!
force modify direct single_component_force  &
   single_component_force_name = .Flap_Mechanism.SFORCE_1  &
   function = "cubspl(time,0,.Flap_Mechanism.myspl,0)*0+VARVAL(.Flap_Mechanism.Input_force)-1000000*DZ(.Flap_Mechanism.inside_drive_eye.tr_eye, .Flap_Mechanism.inside_drive_motor.tr_motor, .Flap_Mechanism.inside_drive_motor.tr_motor)*IF(MODE-4:0,0,1)"
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Mot_spoiler
!
!-------------------------- Adams View UDE Instance ---------------------------!
!
!
ude modify instance  &
   instance_name = .Flap_Mechanism.Controls_Plant_1
!
!--------------------------- Expression definitions ---------------------------!
!
!
defaults coordinate_system  &
   default_coordinate_system = Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_motor.jforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_motor.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_motor.ref, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_eye.iforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.outside_drive_eye.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.outside_drive_motor.jforce, .Flap_Mechanism.outside_drive_eye.ref, "Z"))  &
   relative_to = .Flap_Mechanism.outside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_motor.jforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_motor.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_motor.ref, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_motor
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_eye.iforce  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.iforce, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
marker modify  &
   marker_name = .Flap_Mechanism.inside_drive_eye.ref  &
   orientation =   &
      (ORI_ALONG_AXIS(.Flap_Mechanism.inside_drive_motor.jforce, .Flap_Mechanism.inside_drive_eye.ref, "Z"))  &
   relative_to = .Flap_Mechanism.inside_drive_eye
!
defaults coordinate_system  &
   default_coordinate_system = .Flap_Mechanism.Airframe
!
model display  &
   model_name = Flap_Mechanism
